/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.cli;

import com.ericsson.em.emc.hierarchies.SharedCounterImportManager;
import com.ericsson.em.emc.hierarchies.cli.SharedCounterConfigurationCliManager;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.serialization.SharedCounterSerializer;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogContext;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogger;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

@Singleton
public class SharedCounterConfigurationCliManagerBean
implements SharedCounterConfigurationCliManager {
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    @EJB
    private SharedCounterImportManager sharedCounterImportManager;

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public String createSharedCounterConfiguration(String serializedData, String name) {
        return this.createSharedCounterConfiguration(serializedData, name, true);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="ImportSharedCounterConfiguration", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public String createSharedCounterConfiguration(String serializedData, String name, boolean permissiveMode) {
        this.auditLog(name, permissiveMode);
        SharedCounterConfiguration sharedCounterConfiguration = new SharedCounterSerializer(this.counterTypeRegistry).deserialize(serializedData);
        if (sharedCounterConfiguration != null) {
            if (name != null) {
                sharedCounterConfiguration.setName(name);
            }
            if (sharedCounterConfiguration.getName() == null) {
                throw new IllegalArgumentException("Unique name is missing.");
            }
        } else {
            throw new IllegalArgumentException("Couldn't import due to corrupt data");
        }
        this.sharedCounterImportManager.importSharedCounter(sharedCounterConfiguration, name, permissiveMode);
        return sharedCounterConfiguration.getName();
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ExportSharedCounterConfiguration", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public String exportSharedCounterConfiguration(String name) {
        this.auditLog(name);
        SharedCounterConfiguration sharedCounterConfiguration = this.sharedCounterConfigurationDAO.findByName(name);
        return new SharedCounterSerializer(this.counterTypeRegistry).serialize(sharedCounterConfiguration);
    }

    @Override
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void updateSharedCounterConfiguration(String serializedData, String name) {
        this.updateSharedCounterConfiguration(serializedData, name, true);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="UpdateSharedCounterConfiguration", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public void updateSharedCounterConfiguration(String serializedData, String name, boolean permissiveMode) {
        this.auditLog(name, permissiveMode);
        SharedCounterConfiguration newSharedCounterConfiguration = new SharedCounterSerializer(this.counterTypeRegistry).deserialize(serializedData);
        if (newSharedCounterConfiguration == null) {
            throw new IllegalArgumentException("Couldn't update due to corrupt data");
        }
        this.sharedCounterImportManager.updateSharedCounter(newSharedCounterConfiguration, name, permissiveMode);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ListSharedCounterConfigurationNames", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_CONFIGURATION_ADMIN", "ROLE_ADMIN"})
    public Collection<String> getSharedCounterConfigurationNames() {
        return this.sharedCounterConfigurationDAO.getAll().stream().map(CounterConfiguration::getName).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void auditLog(String name) {
        this.auditLog(name, null);
    }

    private void auditLog(String name, Boolean permissiveMode) {
        AuditTrailLogger logger2 = AuditTrailLogContext.getLogger();
        if (logger2.isLogEnable()) {
            logger2.logIfNotNull("SharedCounterConfigurationName", (Object)name);
            logger2.logIfNotNull("PermissiveMode", (Object)permissiveMode);
        }
    }
}

