/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.em.emc.hierarchies.cli.ProfileEventCommandManager;
import com.ericsson.em.emc.hierarchies.persistence.SafeProfileEventEntity;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import com.ericsson.lwac.utilities.console.TreeTable;
import jakarta.ejb.EJB;
import java.io.PrintWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Command(name="profilechangeevent", group="profile")
@Parameters(separators="=")
@RemoteCommand
public class ProfileEventCommand {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss.SSSS");
    private static final String TIMESTAMP = "Timestamp";
    private static final String EVENT_TYPE = "Event type";
    private static final String PROFILE_NAME = "Profile name";
    private static final String PROFILE_ID = "Profile id";
    private static final TreeTable TABLE = TreeTable.builder().column("Timestamp", TreeTable.ColumnAlignment.LEFT).column("Event type", TreeTable.ColumnAlignment.LEFT).column("Profile name", TreeTable.ColumnAlignment.LEFT).column("Profile id", TreeTable.ColumnAlignment.LEFT).build();
    @EJB
    private ProfileEventCommandManager profileEventCommandManager;

    private static void printResult(RemoteCLIEnvironment environment, List<SafeProfileEventEntity> events) {
        PrintWriter out = environment.getOutputWriter();
        if (events == null || events.isEmpty()) {
            out.println("No profile events found");
        } else {
            out.println("Found profile events");
            events.forEach(ProfileEventCommand::addEventRow);
            out.println(TABLE.printTable());
        }
    }

    private static void addEventRow(SafeProfileEventEntity event) {
        TABLE.beginRow().column(TIMESTAMP, event.getTimestamp().format(TIME_FORMATTER)).column(EVENT_TYPE, event.getProfileEvent()).column(PROFILE_NAME, event.getProfileName()).column(PROFILE_ID, event.getProfileIdentity()).endRow();
    }

    @Command(name="print")
    @Parameters(separators="=", commandDescription="Print profile events.")
    @RemoteCommand(isLoginRequired=false)
    private class Print
    implements RemoteAction {
        @Parameter(description="Name of the profile.", names={"-n", "--name"}, arity=1)
        String profileName;
        @Parameter(description="Show entries starting with date in yyyyMMdd format", names={"-d", "--date"}, arity=1)
        String date = LocalDate.now().minusYears(1L).format(DateTimeFormatter.BASIC_ISO_DATE);
        @Parameter(description="Limit the output to a specific number.", names={"-l", "--limit"}, arity=1)
        int limit = 50;

        private Print() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            try {
                ProfileEventCommand.printResult(environment, ProfileEventCommand.this.profileEventCommandManager.printProfileEventsNoUserId(this.profileName, LocalDate.parse(this.date, DateTimeFormatter.BASIC_ISO_DATE), this.limit));
            }
            catch (Exception e) {
                throw new ExecutionException("Failed: " + e.getMessage());
            }
        }
    }
}

