/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import java.io.Serializable;
import java.util.Objects;

public final class Unit
implements Serializable,
Comparable<Unit> {
    private static final long serialVersionUID = 1L;
    private static final String WILDCARD = "*";
    public static final Unit NONE = new Unit("");
    public static final Unit ANY = new Unit("*");
    private final String value;

    private Unit(String value) {
        this.value = value;
    }

    public static Unit fromString(String value) {
        if (value == null || value.isEmpty()) {
            return NONE;
        }
        if (WILDCARD.equals(value)) {
            return ANY;
        }
        return new Unit(value);
    }

    public static Unit fromCurrency(Currency currency) {
        if (currency == null) {
            return NONE;
        }
        return Unit.fromString(currency.getCurrencyCode());
    }

    public static Unit fromMoney(Money money) {
        if (money == null) {
            return NONE;
        }
        return Unit.fromCurrency(money.getCurrency());
    }

    public String getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Unit other = (Unit)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(Unit that) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.value, that.value);
    }

    public boolean match(Unit that) {
        Objects.requireNonNull(that);
        if (WILDCARD.equals(this.value) || WILDCARD.equals(that.value)) {
            return !this.isEmpty() && !that.isEmpty();
        }
        return this.value.equals(that.value);
    }
}

