/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.MissingValidatingSharedCounterImportManagerException;
import com.ericsson.em.emc.hierarchies.SharedCounterImportManager;
import com.ericsson.em.emc.hierarchies.counters.SharedCounterImportHandler;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;

@Singleton
public class SharedCounterImportManagerBean
implements SharedCounterImportManager {
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    private SharedCounterImportHandler validatingSharedCounterImportHandler;
    private SharedCounterImportHandler permissiveSharedCounterImportHandler;

    @Override
    public void importSharedCounter(SharedCounterConfiguration sharedCounterConfiguration, String name, boolean permissiveMode) {
        if (permissiveMode) {
            this.permissiveSharedCounterImportHandler.importSharedCounter(sharedCounterConfiguration, name);
        } else {
            if (this.validatingSharedCounterImportHandler == null) {
                throw new MissingValidatingSharedCounterImportManagerException();
            }
            this.validatingSharedCounterImportHandler.importSharedCounter(sharedCounterConfiguration, name);
        }
    }

    @Override
    public void updateSharedCounter(SharedCounterConfiguration sharedCounterConfiguration, String name, boolean permissiveMode) {
        SharedCounterConfiguration existingSharedCounterConfiguration = this.sharedCounterConfigurationDAO.findByName(name);
        if (permissiveMode) {
            this.permissiveSharedCounterImportHandler.updateSharedCounter(existingSharedCounterConfiguration.getId(), sharedCounterConfiguration, name);
        } else {
            if (this.validatingSharedCounterImportHandler == null) {
                throw new MissingValidatingSharedCounterImportManagerException();
            }
            this.validatingSharedCounterImportHandler.updateSharedCounter(existingSharedCounterConfiguration.getId(), sharedCounterConfiguration, name);
        }
    }

    @Override
    public void registerValidatingSharedCounterImportHandler(SharedCounterImportHandler sharedCounterImportHandler) {
        this.validatingSharedCounterImportHandler = sharedCounterImportHandler;
    }

    @Override
    public void registerPermissiveSharedCounterImportHandler(SharedCounterImportHandler sharedCounterImportHandler) {
        this.permissiveSharedCounterImportHandler = sharedCounterImportHandler;
    }
}

