/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.helper.ValidationHelper;
import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.MissingValidatingProfileImportManagerException;
import com.ericsson.em.emc.hierarchies.ProfileImportHandler;
import com.ericsson.em.emc.hierarchies.ProfileImportListener;
import com.ericsson.em.emc.hierarchies.ProfileImportManager;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventLoggerDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.serialization.ProfileSerializer;
import com.ericsson.em.emc.lifecycle.ProfileLifecycleEventManager;
import com.ericsson.em.emc.profile.PermissionWithProperty;
import com.ericsson.em.emc.tag.persistence.Tag;
import com.ericsson.em.emc.tag.persistence.TagDAO;
import com.ericsson.lwac.security.session.SessionContext;
import com.ericsson.lwac.transaction.TransactionAttributeTimeout;
import com.google.gson.JsonParseException;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class ProfileImportManagerBean
implements ProfileImportManager {
    public static final Set<Double> VERSIONS = Collections.unmodifiableSet(new HashSet<Double>(Arrays.asList(2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6)));
    public static final String FLAG_PERMISSIVE_MODE = "permissive-mode";
    public static final String SERVICE_PERMISSIONS = "Permissions";
    public static final String SERVICE_TAGS = "Tags";
    private final CopyOnWriteArraySet<ProfileImportListener> listeners = new CopyOnWriteArraySet();
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @EJB
    private ProfileLifecycleEventManager profileLifecycleEventManager;
    @EJB
    private HierarchyManager hierarchyManager;
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    private ProfileImportHandler validatingProfileImportHandler;
    private ProfileImportHandler permissiveProfileImportHandler;
    private ProfileSerializer profileSerializer;
    @EJB
    private ProfileEventLoggerDAO profileEventLoggerDAO;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private TagDAO tagDAO;

    @PostConstruct
    public void postConstruct() {
        this.profileSerializer = new ProfileSerializer(this.counterTypeRegistry);
    }

    void setProfileSerializer(ProfileSerializer profileSerializer) {
        this.profileSerializer = profileSerializer;
    }

    @Override
    public void registerListener(ProfileImportListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public void registerValidatingProfileImportHandler(ProfileImportHandler profileImportHandler) {
        this.validatingProfileImportHandler = profileImportHandler;
    }

    @Override
    public void registerPermissiveProfileImportHandler(ProfileImportHandler profileImportHandler) {
        this.permissiveProfileImportHandler = profileImportHandler;
    }

    @Override
    public void cloneProfile(String newProfileName, String serializedData, Set<String> flags) {
        this.doImportProfile(newProfileName, serializedData, flags, true);
    }

    @Override
    @TransactionAttributeTimeout(timeout=5, timeUnit=TimeUnit.MINUTES)
    public void importProfile(String newProfileName, String serializedData, Set<String> flags) {
        this.doImportProfile(newProfileName, serializedData, flags, false);
    }

    @Override
    public void importProfile(String newProfileName, String serializedData, String profileType, Set<String> flags) {
        try {
            String aProperty;
            Profile profile = this.profileSerializer.deserialize(serializedData);
            if (null != profileType && (aProperty = this.hierarchyManager.findProperty(profile, "General", "Profile Type")) != null && !profileType.equals(aProperty)) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_TYPE_MISMATCH).add("FileprofileType", aProperty).add("profileType", profileType).add("message", "profile cannot be imported for").create();
            }
            this.importProfile(newProfileName, serializedData, flags);
        }
        catch (JsonParseException e) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_JSON_INVALID_FILE).add("message", "Invalid file").create();
        }
    }

    private void doImportProfile(String newProfileName, String serializedData, Set<String> flags, boolean isCloning) {
        try {
            Profile profile = this.profileSerializer.deserialize(serializedData);
            if (!serializedData.contains("version")) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_VERSION_MANDATORY).add("message", "Profile version is mandatory").create();
            }
            if (!VERSIONS.contains(profile.getProfileVersion())) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_VERSION_MISMATCH).add("message", "Profile cannot be imported as it is not compatible with current version of profile.").create();
            }
            if (!ValidationHelper.validateProfileName(newProfileName)) {
                String invalidNameMessage = ValidationHelper.getInvalidProfileNameMessage();
                throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE_NAME).add("name", newProfileName).add("message", invalidNameMessage).create();
            }
            if (!ValidationHelper.validateProfileModifierAndThresholdConfigurationClassNames(profile.getServices())) {
                String invalidClassName = ValidationHelper.getInvalidProfileClassNameMessage();
                throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE).add("name", newProfileName).add("message", invalidClassName).create();
            }
            profile.getServices().stream().filter(service -> service.getName().equals(SERVICE_PERMISSIONS)).map(ProfileService::getChildren).flatMap(Collection::stream).forEach(profileService -> profileService.getProperties().stream().forEach(property -> {
                if (!PermissionWithProperty.fromPermission(profileService.getName()).isValid(property.getValue())) {
                    throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE).add("name", newProfileName).add("message", String.format("Property %s value is not valid for permission %s", property.getName(), profileService.getName())).create();
                }
            }));
            this.validateTags(profile, newProfileName);
            String internalAccountProfileName = this.hierarchyManager.findProperty(profile, "Internal Account", "Default Account");
            this.validateAccount(internalAccountProfileName);
            this.createProfile(profile, newProfileName, flags, isCloning);
            this.profileLifecycleEventManager.importedProfile(profile);
        }
        catch (JsonParseException e) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_JSON_INVALID_FILE).add("message", "Invalid file").create();
        }
    }

    @Override
    public void updateProfile(String existingProfileName, String serializedProfile, Set<String> flags) {
        Profile profile;
        try {
            profile = new ProfileSerializer(this.counterTypeRegistry).deserialize(serializedProfile);
        }
        catch (JsonParseException e) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_JSON_INVALID_FILE).add("message", "Invalid file.").create();
        }
        if (!serializedProfile.contains("version")) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_VERSION_MANDATORY).add("message", "Profile version is mandatory.").create();
        }
        if (!VERSIONS.contains(profile.getProfileVersion())) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_VERSION_MISMATCH).add("message", "Profile cannot be imported as it is not compatible with current version of profile.").create();
        }
        Profile existingProfile = this.profileDAO.findByName(existingProfileName);
        if (existingProfile == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_NOT_FOUND).add("name", existingProfileName).create();
        }
        if (flags.contains(FLAG_PERMISSIVE_MODE)) {
            this.permissiveProfileImportHandler.updateProfile(profile, existingProfile);
        } else {
            if (this.validatingProfileImportHandler == null) {
                throw new MissingValidatingProfileImportManagerException();
            }
            profile.setName(existingProfileName);
            this.validatingProfileImportHandler.updateProfile(profile, existingProfile);
        }
    }

    private void validateAccount(String internalAccountProfileName) {
        Profile internalAccountProfile;
        if (null != internalAccountProfileName && !internalAccountProfileName.isEmpty() && null == (internalAccountProfile = this.hierarchyManager.findProfile(internalAccountProfileName))) {
            throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE).add("name", internalAccountProfileName).add("message", "Account Profile does not exist.").create();
        }
    }

    private void validateTags(Profile profile, String newProfileName) {
        List tags = profile.getServices().stream().filter(service -> service.getName().equals(SERVICE_TAGS)).map(ProfileService::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
        Map tagCountMap = tags.stream().map(tag -> tag.getName().toLowerCase()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        tagCountMap.forEach((name, count) -> {
            if (count > 1L) {
                throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE).add("name", newProfileName).add("message", String.format("Duplicate tag found: %s", name)).create();
            }
        });
        List existingTags = this.tagDAO.findAll().stream().map(existingTag -> existingTag.getName().toLowerCase()).collect(Collectors.toList());
        tags.stream().forEach(tag -> {
            if (!existingTags.contains(tag.getName().toLowerCase())) {
                throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_PROFILE).add("name", newProfileName).add("message", String.format("Tag %s does not exist", tag.getName())).create();
            }
        });
    }

    private void correctTagsCasing(Profile profile) {
        List<ProfileService> tagServices = profile.getServices().stream().filter(service -> service.getName().equals(SERVICE_TAGS)).flatMap(it -> it.getChildren().stream()).collect(Collectors.toList());
        if (tagServices.isEmpty()) {
            return;
        }
        List existingTags = this.tagDAO.findAll().stream().map(Tag::getName).collect(Collectors.toList());
        tagServices.forEach(it -> it.setName(existingTags.stream().filter(existingTag -> existingTag.equalsIgnoreCase(it.getName())).findFirst().orElse(it.getName())));
    }

    private void createProfile(Profile profile, String newProfileName, Set<String> flags, boolean isCloning) {
        this.correctTagsCasing(profile);
        profile.setName(newProfileName);
        for (ProfileImportListener listener : this.listeners) {
            listener.onProfileImport(profile, flags);
        }
        profile.setProfileVersion(2.6);
        if (flags.contains(FLAG_PERMISSIVE_MODE)) {
            if (isCloning) {
                this.permissiveProfileImportHandler.cloneProfile(newProfileName, profile, flags);
            } else {
                this.permissiveProfileImportHandler.importProfile(newProfileName, profile, flags);
            }
        } else {
            if (this.validatingProfileImportHandler == null) {
                throw new MissingValidatingProfileImportManagerException();
            }
            this.validatingProfileImportHandler.importProfile(newProfileName, profile, flags);
        }
    }
}

