/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.ProfileExportManager;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.serialization.ProfileSerializer;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Objects;
import java.util.stream.Collectors;

@Singleton
public class ProfileExportManagerBean
implements ProfileExportManager {
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    @EJB
    private HierarchyManager hierarchyManager;
    private static final String PROPERTY_CREATED_TIME = "Created time";
    private static final String PROPERTY_CREATED_BY_USER = "Created by user";
    private static final String PROPERTY_LATEST_UPDATE_TIME = "Latest update time";
    private static final String PROPERTY_LATEST_UPDATE_BY_USER = "Latest update by user";
    private static final String SERVICE_GENERAL = "General";

    @Override
    public String exportProfile(String profileName) {
        Objects.requireNonNull(profileName);
        Profile profile = this.profileDAO.findByName(profileName);
        if (profile == null) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PROFILE_NOT_FOUND).add("name", profileName).create();
        }
        profile.setProfileVersion(2.6);
        this.removeMetadata(profile);
        return new ProfileSerializer(this.counterTypeRegistry).serialize(profile);
    }

    private void removeMetadata(Profile profile) {
        ProfileService generalService = this.hierarchyManager.findService(profile, SERVICE_GENERAL);
        if (generalService != null) {
            generalService.setProperties(generalService.getProperties().stream().filter(property -> !PROPERTY_CREATED_TIME.equals(property.getName()) && !PROPERTY_CREATED_BY_USER.equals(property.getName()) && !PROPERTY_LATEST_UPDATE_TIME.equals(property.getName()) && !PROPERTY_LATEST_UPDATE_BY_USER.equals(property.getName())).collect(Collectors.toList()));
        }
    }
}

