/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.PermissiveProfileImportHandler;
import com.ericsson.em.emc.hierarchies.ProfileConfigurationService;
import com.ericsson.em.emc.hierarchies.ProfileImportHandler;
import com.ericsson.em.emc.hierarchies.ProfileImportManager;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterIdentifierMatchParameters;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelation;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventEntity;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventLoggerDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterOverride;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationDAO;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.security.session.SessionContext;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Singleton
public class PermissiveProfileImportHandlerBean
implements PermissiveProfileImportHandler {
    private static final String PROPERTY_PROFILE_TYPE = "Profile Type";
    private static final String SERVICE_GENERAL = "General";
    private static final String PROFILE_TYPE_ACCOUNT_HOLDER = "Account Holder";
    private static final String SERVICE_PERMISSIONS = "Permissions";
    private static final String ROLE_ALLOWED_COMMUNICATION_CHANNELS = "ROLE_ALLOWED_COMMUNICATION_CHANNELS";
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @EJB
    private ThresholdConfigurationDAO thresholdConfigurationDAO;
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private ProfileCounterRelationDAO profileCounterRelationDAO;
    @EJB
    private ModifierConfigurationDAO modifierConfigurationDAO;
    @EJB
    private PropertyDAO propertyDAO;
    @EJB
    private ProfileImportManager profileImportManager;
    @EJB
    private ProfileEventLoggerDAO profileEventLoggerDAO;
    @EJB
    private HierarchyManager hierarchyManager;
    @EJB
    private ProfileReferenceDAO profileReferenceDAO;
    @Resource
    private ProfileConfigurationService profileConfigurationService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SessionContext sessionContext;

    @PostConstruct
    public void postConstruct() {
        this.profileImportManager.registerPermissiveProfileImportHandler((ProfileImportHandler)this.applicationContext.getThis());
    }

    @Override
    public void importProfile(String profileName, Profile profile, Set<String> flags) {
        this.doImportProfile(profile);
        this.createProfileEvent(profileName, profile, ProfileEventEntity.ProfileEvent.IMPORTED);
    }

    @Override
    public void cloneProfile(String profileName, Profile profile, Set<String> flags) {
        this.doImportProfile(profile);
        this.createProfileEvent(profileName, profile, ProfileEventEntity.ProfileEvent.CLONED);
    }

    private void doImportProfile(Profile profile) {
        if (this.isAccountHolderProfile(profile)) {
            this.checkUserProfileCount();
        }
        this.profileDAO.create(profile);
        LinkedList<ProfileService> coreServices = new LinkedList<ProfileService>(profile.getServices());
        profile.getServices().clear();
        for (ProfileService coreService : coreServices) {
            this.profileServiceDAO.create(coreService, profile);
            this.manageService(coreService);
        }
        if (this.isAccountHolderProfile(profile)) {
            this.updatePermissionServiceWithCommunicationChannels(profile);
        }
    }

    private void checkUserProfileCount() {
        long allowedUserProfileCount;
        long userProfileCount = this.profileDAO.countAllByType(PROFILE_TYPE_ACCOUNT_HOLDER);
        if (userProfileCount >= (allowedUserProfileCount = (long)this.profileConfigurationService.getMaximumNumberOfAccountHolderProfiles())) {
            throw new UserExceptionBuilder(CoreUserErrorCode.TOO_MANY_USER_PROFILES).add("message", "Maximum number of allowed User Profiles has been reached").create();
        }
    }

    @Override
    public void updateProfile(Profile profile, Profile existingProfile) {
        Profile existingProfileClone = existingProfile.deepClone();
        existingProfileClone.setServices(new ArrayList<ProfileService>(existingProfileClone.getServices()));
        this.validateInterestBearingChange(profile, existingProfile);
        long numberOfRatingCountersInExistingProfile = this.getNumberOfRatingCounters(existingProfileClone.getServices());
        long numberOfRatingCountersInUpdatedProfile = this.getNumberOfRatingCounters(profile.getServices());
        boolean isExceededLimitOfRatingCountersAllowed = numberOfRatingCountersInUpdatedProfile > (long)this.profileConfigurationService.getMaximumNumberOfRatingCounters() && numberOfRatingCountersInUpdatedProfile <= numberOfRatingCountersInExistingProfile;
        LinkedList<ProfileService> services = new LinkedList<ProfileService>(existingProfileClone.getServices());
        for (ProfileService service : services) {
            this.deepDeleteService(service);
        }
        existingProfileClone.getServices().clear();
        services = new LinkedList<ProfileService>(profile.getServices());
        for (ProfileService service : services) {
            this.profileServiceDAO.create(service, existingProfileClone);
            this.deepCreateService(service, isExceededLimitOfRatingCountersAllowed);
        }
        existingProfile.setProfileVersion(profile.getProfileVersion());
        this.profileDAO.update(existingProfileClone);
        this.createProfileEvent(existingProfileClone.getName(), existingProfileClone, ProfileEventEntity.ProfileEvent.EDITED);
    }

    private long getNumberOfRatingCounters(List<ProfileService> services) {
        long numberOfRatingCounters = 0L;
        for (ProfileService profileService : services) {
            numberOfRatingCounters += profileService.getIndividualCounterConfigurations().stream().filter(CounterConfiguration::isRatingCounter).count();
            numberOfRatingCounters += this.getNumberOfRatingCounters(profileService.getChildren());
        }
        return numberOfRatingCounters;
    }

    private void deepCreateService(ProfileService service, boolean isExceededLimitOfRatingCountersAllowed) {
        LinkedList<IndividualCounterConfiguration> individualCounterConfigurations = new LinkedList<IndividualCounterConfiguration>(service.getIndividualCounterConfigurations());
        LinkedList<ThresholdConfiguration> thresholdConfigurations = new LinkedList<ThresholdConfiguration>(service.getThresholdConfigurations());
        LinkedList<Property> properties = new LinkedList<Property>(service.getProperties());
        LinkedList<ProfileService> children = new LinkedList<ProfileService>(service.getChildren());
        service.getIndividualCounterConfigurations().clear();
        service.getThresholdConfigurations().clear();
        service.getProperties().clear();
        service.getChildren().clear();
        for (IndividualCounterConfiguration individualCounterConfiguration : individualCounterConfigurations) {
            if (individualCounterConfiguration == null) {
                throw new InvalidParameterException("Counter configurations array from the profile service '" + service.getName() + "' contains a null element. Possible reason: trailing comma.");
            }
            LinkedList<ModifierConfiguration> modifierConfigurations = new LinkedList<ModifierConfiguration>(individualCounterConfiguration.getModifierConfigurations());
            individualCounterConfiguration.getModifierConfigurations().clear();
            CounterIdentifierMatchParameters validatorParams = (CounterIdentifierMatchParameters)CounterIdentifierMatchParameters.build().counterType(individualCounterConfiguration.getCounterType()).unit(individualCounterConfiguration.getUnit()).periodType(individualCounterConfiguration.getPeriodType()).periodLength(individualCounterConfiguration.getPeriodLength()).identifier(individualCounterConfiguration.getIdentifier()).get();
            if (this.individualCounterConfigurationManager.isIdentifierValidFor(validatorParams)) {
                IndividualCounterConfiguration createdConfig = this.individualCounterConfigurationManager.create(individualCounterConfiguration, service, isExceededLimitOfRatingCountersAllowed);
                for (ModifierConfiguration modifierConfiguration : modifierConfigurations) {
                    this.modifierConfigurationDAO.create(modifierConfiguration, createdConfig);
                }
                continue;
            }
            throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_COUNTER_IDENTIFIER).add("name", service.getName()).add("counter", individualCounterConfiguration.getName()).add("identifier", individualCounterConfiguration.getIdentifier()).add("message", "Invalid counter identifier").create();
        }
        ArrayList<String> profileCounterRelations = new ArrayList<String>(service.getSharedCounterRelations());
        ArrayList<SharedCounterOverride> sharedCounterOverrides = new ArrayList<SharedCounterOverride>(service.getSharedCounterOverrides());
        service.getSharedCounterRelations().clear();
        service.getSharedCounterOverrides().clear();
        for (String sharedCounterConfigurationName : profileCounterRelations) {
            SharedCounterConfiguration sharedCounterConfiguration = this.sharedCounterConfigurationDAO.findByName(sharedCounterConfigurationName);
            if (sharedCounterConfiguration != null) {
                service.addSharedCounterConfiguration(sharedCounterConfiguration);
                BigDecimal limit = sharedCounterOverrides.stream().filter(it -> it.getName().equals(sharedCounterConfigurationName)).findFirst().map(SharedCounterOverride::getLimit).orElse(null);
                service.addSharedCounterOverride(SharedCounterOverride.newBuilder().name(sharedCounterConfigurationName).limit(limit).build());
                this.profileCounterRelationDAO.create(new ProfileCounterRelation(service.getId(), sharedCounterConfigurationName, limit));
                continue;
            }
            throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_COUNTER_RELATION).add("name", service.getName()).add("counter", sharedCounterConfigurationName).add("message", "Can not find counter configuration").create();
        }
        for (ThresholdConfiguration thresholdConfiguration : thresholdConfigurations) {
            this.thresholdConfigurationDAO.create(thresholdConfiguration, service);
        }
        for (Property property : properties) {
            this.propertyDAO.create(property, service);
        }
        for (ProfileService child : children) {
            this.profileServiceDAO.create(child, service);
            this.deepCreateService(child, isExceededLimitOfRatingCountersAllowed);
        }
    }

    private void deepDeleteService(ProfileService service) {
        this.profileServiceDAO.deleteCascade(service);
    }

    private boolean isAccountHolderProfile(Profile profile) {
        for (ProfileService profileService : profile.getServices()) {
            Property property;
            if (!SERVICE_GENERAL.equals(profileService.getName()) || (property = profileService.getProperty(PROPERTY_PROFILE_TYPE)) == null) continue;
            return PROFILE_TYPE_ACCOUNT_HOLDER.equals(property.getValue());
        }
        return false;
    }

    private void updatePermissionServiceWithCommunicationChannels(Profile profile) {
        ProfileService communicationChannelService;
        ProfileService permissionService = this.profileServiceDAO.findByName(SERVICE_PERMISSIONS, profile);
        if (permissionService == null) {
            permissionService = this.profileServiceDAO.create(new ProfileService(SERVICE_PERMISSIONS), profile);
        }
        if ((communicationChannelService = permissionService.getChildByName(ROLE_ALLOWED_COMMUNICATION_CHANNELS)) == null) {
            this.profileServiceDAO.create(new ProfileService(ROLE_ALLOWED_COMMUNICATION_CHANNELS), permissionService);
        }
    }

    private void manageService(ProfileService service) {
        LinkedList<IndividualCounterConfiguration> individualCounterConfigurations = new LinkedList<IndividualCounterConfiguration>(service.getIndividualCounterConfigurations());
        LinkedList<ThresholdConfiguration> thresholdConfigurations = new LinkedList<ThresholdConfiguration>(service.getThresholdConfigurations());
        LinkedList<Property> properties = new LinkedList<Property>(service.getProperties());
        LinkedList<ProfileService> children = new LinkedList<ProfileService>(service.getChildren());
        service.getIndividualCounterConfigurations().clear();
        service.getThresholdConfigurations().clear();
        service.getProperties().clear();
        service.getChildren().clear();
        for (IndividualCounterConfiguration individualCounterConfiguration : individualCounterConfigurations) {
            LinkedList<ModifierConfiguration> modifierConfigurations = new LinkedList<ModifierConfiguration>(individualCounterConfiguration.getModifierConfigurations());
            individualCounterConfiguration.getModifierConfigurations().clear();
            CounterIdentifierMatchParameters validatorParams = (CounterIdentifierMatchParameters)CounterIdentifierMatchParameters.build().counterType(individualCounterConfiguration.getCounterType()).unit(individualCounterConfiguration.getUnit()).periodType(individualCounterConfiguration.getPeriodType()).periodLength(individualCounterConfiguration.getPeriodLength()).identifier(individualCounterConfiguration.getIdentifier()).get();
            if (this.individualCounterConfigurationManager.isIdentifierValidFor(validatorParams)) {
                this.individualCounterConfigurationManager.create(individualCounterConfiguration, service);
                for (ModifierConfiguration modifierConfiguration : modifierConfigurations) {
                    this.modifierConfigurationDAO.create(modifierConfiguration, individualCounterConfiguration);
                }
                continue;
            }
            throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_COUNTER_IDENTIFIER).add("name", service.getName()).add("counter", individualCounterConfiguration.getName()).add("identifier", individualCounterConfiguration.getIdentifier()).add("message", "Invalid counter identifier").create();
        }
        for (ThresholdConfiguration thresholdConfiguration : thresholdConfigurations) {
            this.thresholdConfigurationDAO.create(thresholdConfiguration, service);
        }
        ArrayList<String> profileCounterRelations = new ArrayList<String>(service.getSharedCounterRelations());
        ArrayList<SharedCounterOverride> sharedCounterOverrides = new ArrayList<SharedCounterOverride>(service.getSharedCounterOverrides());
        service.getSharedCounterRelations().clear();
        service.getSharedCounterOverrides().clear();
        for (String sharedCounterConfigurationName : profileCounterRelations) {
            SharedCounterConfiguration sharedCounterConfiguration = this.sharedCounterConfigurationDAO.findByName(sharedCounterConfigurationName);
            if (sharedCounterConfiguration != null) {
                service.addSharedCounterConfiguration(sharedCounterConfiguration);
                BigDecimal limit = sharedCounterOverrides.stream().filter(it -> it.getName().equals(sharedCounterConfigurationName)).findFirst().map(SharedCounterOverride::getLimit).orElse(null);
                service.addSharedCounterOverride(SharedCounterOverride.newBuilder().name(sharedCounterConfigurationName).limit(limit).build());
                this.profileCounterRelationDAO.create(new ProfileCounterRelation(service.getId(), sharedCounterConfigurationName, limit));
                continue;
            }
            throw new UserExceptionBuilder(CoreUserErrorCode.INVALID_COUNTER_RELATION).add("name", service.getName()).add("counter", sharedCounterConfigurationName).add("message", "Can not find counter configuration").create();
        }
        for (Property property : properties) {
            this.propertyDAO.create(property, service);
        }
        for (ProfileService child : children) {
            this.profileServiceDAO.create(child, service);
            this.manageService(child);
        }
    }

    private void createProfileEvent(String profileName, Profile profile, ProfileEventEntity.ProfileEvent event) {
        this.profileEventLoggerDAO.create(ProfileEventEntity.newBuilder().timestamp(LocalDateTime.now()).profileEvent(event).profileName(profileName).profileIdentity(profile.getId()).userIdentity(this.sessionContext.isSessionExisting() ? this.sessionContext.getEffectiveUser().toString() : "ID:unknown/unknown").build());
    }

    private void validateInterestBearingChange(Profile profile, Profile existingProfile) {
        boolean wasInterestBearingBefore = "Interest bearing".equals(existingProfile.getServices().stream().filter(it -> SERVICE_GENERAL.equals(it.getName())).findFirst().map(it -> it.getPropertyValue("Interest")).orElse(null));
        boolean isInterestBearing = "Interest bearing".equals(profile.getServices().stream().filter(it -> SERVICE_GENERAL.equals(it.getName())).findFirst().map(it -> it.getPropertyValue("Interest")).orElse(null));
        if (isInterestBearing != wasInterestBearingBefore && this.profileReferenceDAO.isProfileInUse(existingProfile)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.NOT_ALLOWED_TO_CHANGE_INTEREST_BEARING_STATUS_ON_PROFILE_IN_USE).create();
        }
    }
}

