/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.lwac.utilities.StringUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Currencies
implements Serializable,
Iterable<Currency> {
    private static final long serialVersionUID = -2752395169259950223L;
    public static final Currencies EMPTY = new Currencies(Collections.emptySet());
    private static final String NONE = "-";
    private static final String DELIMITER = ",";
    private final Set<Currency> currencies;
    private final String delimiter;

    protected Currencies(Builder builder) {
        this.currencies = builder.currencies;
        this.delimiter = builder.delimiter;
    }

    protected Currencies(Set<Currency> currencies) {
        this.currencies = currencies;
        this.delimiter = null;
    }

    protected Currencies(Set<Currency> currencies, String delimiter) {
        this.currencies = currencies;
        this.delimiter = delimiter;
    }

    public Set<Currency> getCurrencies() {
        return this.currencies;
    }

    public String getCurrenciesAsString() {
        if (this.delimiter != null) {
            return String.join((CharSequence)this.delimiter, this.transform(this.currencies));
        }
        return NONE;
    }

    public static Currencies fromString(String currencies) {
        return Currencies.fromString(currencies, DELIMITER);
    }

    public static Currencies fromString(String currencies, String delimiter) {
        if (StringUtilities.isBlank(currencies) || NONE.equals(currencies.trim())) {
            return EMPTY;
        }
        String[] currencyArray = currencies.trim().split(delimiter);
        TreeSet<Currency> result = new TreeSet<Currency>();
        for (String currency : currencyArray) {
            result.add(Currency.getInstance(currency.trim()));
        }
        return new Currencies(Collections.unmodifiableSet(result), delimiter);
    }

    public static Currencies create(Collection<Currency> currencies) {
        return Currencies.create(currencies, DELIMITER);
    }

    public static Currencies create(Collection<Currency> currencies, String delimiter) {
        if (currencies == null || currencies.isEmpty()) {
            return EMPTY;
        }
        return new Currencies(Collections.unmodifiableSet(new TreeSet<Currency>(currencies)), delimiter);
    }

    public boolean isEmpty() {
        return this.currencies.isEmpty();
    }

    public boolean contains(Currency currency) {
        return this.currencies.contains(currency);
    }

    public String toString() {
        return this.getCurrenciesAsString();
    }

    @Override
    public Iterator<Currency> iterator() {
        return this.currencies.iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currencies == null ? 0 : this.currencies.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Currencies other = (Currencies)obj;
        if (this.currencies == null ? other.currencies != null : !this.currencies.equals(other.currencies)) {
            return false;
        }
        return !(this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter));
    }

    private List<String> transform(Set<Currency> currencies) {
        ArrayList<String> result = new ArrayList<String>();
        for (Currency currency : currencies) {
            result.add(currency.getCurrencyCode());
        }
        return result;
    }

    public static final class Builder {
        private Set<Currency> currencies = new TreeSet<Currency>();
        private String delimiter = ",";

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder currencies(Set<Currency> currencies) {
            this.currencies = currencies;
            return this;
        }

        public Builder add(String currency) {
            if (!StringUtilities.isBlank(currency)) {
                this.currencies.add(Currency.getInstance(currency.trim()));
            }
            return this;
        }

        public Builder add(Currency currency) {
            if (currency != null) {
                this.currencies.add(currency);
            }
            return this;
        }

        public Currencies build() {
            if (this.currencies.isEmpty() && Currencies.DELIMITER.equals(this.delimiter)) {
                return EMPTY;
            }
            return new Currencies(this);
        }
    }
}

