/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.CounterBalanceManager;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.List;
import org.joda.time.DateTime;

@Singleton
public class CounterBalanceManagerBean
implements CounterBalanceManager {
    @EJB
    private CounterBalanceDAO counterBalanceDAO;

    @Override
    public void copyProfileSharedCounterBalaces(ProfileReference source, ProfileReference target, String serviceName) {
        ProfileService sourceProfileService = this.getProfileServiceByName(source.getProfile(), serviceName);
        ProfileService targetProfileService = this.getProfileServiceByName(target.getProfile(), serviceName);
        if (sourceProfileService != null && targetProfileService != null) {
            List<String> targetSharedCounterRelations = targetProfileService.getSharedCounterRelations();
            sourceProfileService.getSharedCounterConfigurations().forEach(scc -> {
                if (targetSharedCounterRelations.contains(scc.getName())) {
                    this.doCopyCounterBalance((CounterConfiguration)scc, source, target);
                }
            });
        }
    }

    @Override
    public void aggregateProfileSharedCounterBalances(ProfileReference source, ProfileReference target, String serviceName) {
        ProfileService sourceProfileService = this.getProfileServiceByName(source.getProfile(), serviceName);
        ProfileService targetProfileService = this.getProfileServiceByName(target.getProfile(), serviceName);
        if (sourceProfileService != null && targetProfileService != null) {
            List<String> targetSharedCounterRelations = targetProfileService.getSharedCounterRelations();
            sourceProfileService.getSharedCounterConfigurations().forEach(scc -> {
                if (targetSharedCounterRelations.contains(scc.getName())) {
                    this.doAggregateCounterBalance((CounterConfiguration)scc, source, target);
                }
            });
        }
    }

    private ProfileService getProfileServiceByName(Profile profile, String serviceName) {
        for (ProfileService service : profile.getServices()) {
            if (!serviceName.equals(service.getName())) continue;
            return service;
        }
        return null;
    }

    private void doCopyCounterBalance(CounterConfiguration cc, ProfileReference source, ProfileReference target) {
        CounterBalance existingBalance = this.findCurrentCounterBalance(cc, source);
        if (existingBalance == null) {
            return;
        }
        long referenceId = target.getProfileReferenceId();
        long countertype = 0L;
        if (cc.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.SHARED) {
            countertype = 1L;
            referenceId = target.getAccountHolderEUIId();
        }
        CounterBalance newBalance = existingBalance.copyToReferenceId(referenceId);
        newBalance.setCounterType(countertype);
        this.counterBalanceDAO.create(newBalance);
    }

    private void doAggregateCounterBalance(CounterConfiguration cc, ProfileReference source, ProfileReference target) {
        long referenceId;
        CounterBalance sourceBalance = this.findCurrentCounterBalance(cc, source);
        CounterBalance targetBalance = this.findCurrentCounterBalance(cc, target);
        if (sourceBalance == null) {
            return;
        }
        long l = referenceId = cc.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL ? target.getProfileReferenceId() : target.getAccountHolderEUIId().longValue();
        if (targetBalance == null) {
            targetBalance = sourceBalance.copyToReferenceId(referenceId);
            targetBalance.setCounterType(sourceBalance.getCounterType());
            this.counterBalanceDAO.create(targetBalance);
        } else {
            targetBalance.updateBalance(sourceBalance);
            this.counterBalanceDAO.update(targetBalance);
        }
    }

    private CounterBalance findCurrentCounterBalance(CounterConfiguration cc, ProfileReference source) {
        return this.counterBalanceDAO.findCounterBalance(cc, source, DateTime.now());
    }
}

