/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.helper;

import com.ericsson.em.emc.hierarchies.counters.Modifier;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.threshold.Threshold;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ValidationHelper {
    private static final String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static final String DOMAIN = "(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern PATTERN = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$", 2);
    private static final String ATOMPROFILE = "[\\p{IsAlphabetic}\\p{IsDigit}]";
    private static final String SEPARATORSPROFILE = "[\\p{Blank}_.]";
    private static final Pattern PATTERNPROFILE = Pattern.compile("^(?:[\\p{IsAlphabetic}\\p{IsDigit}]+(?:[\\p{Blank}_.][\\p{IsAlphabetic}\\p{IsDigit}]+)*)");
    private static final String INVALID_CLASS = "Invalid class found in profile.";

    public static boolean validateEmail(String emailAddress) {
        Matcher matcher;
        return emailAddress != null && !emailAddress.isEmpty() && (matcher = PATTERN.matcher(emailAddress)).matches();
    }

    public static boolean validateProfileName(String profileName) {
        Matcher matcher;
        return profileName != null && !profileName.isEmpty() && profileName.length() <= 64 && (matcher = PATTERNPROFILE.matcher(profileName)).matches();
    }

    public static boolean validateProfileModifierAndThresholdConfigurationClassNames(List<ProfileService> services) {
        List modifierConfigurationsWithFaultyClasses = services.stream().map(ProfileService::getIndividualCounterConfigurations).flatMap(Collection::stream).map(CounterConfiguration::getModifierConfigurations).flatMap(Collection::stream).filter(modifierConfiguration -> !ValidationHelper.checkIfClassDoesImplementInterface(modifierConfiguration.getClassName(), Modifier.class)).collect(Collectors.toList());
        List thresholdConfigurationsWithFaultyClasses = services.stream().map(ProfileService::getThresholdConfigurations).flatMap(Collection::stream).filter(thresholdConfiguration -> !ValidationHelper.checkIfClassDoesImplementInterface(thresholdConfiguration.getClassName(), Threshold.class)).collect(Collectors.toList());
        return modifierConfigurationsWithFaultyClasses.isEmpty() && thresholdConfigurationsWithFaultyClasses.isEmpty();
    }

    private static boolean checkIfClassDoesImplementInterface(String className, Class<?> wantedInterface) {
        if (className == null || wantedInterface == null) {
            return true;
        }
        Class<?> clazz = ValidationHelper.createClassFromClassName(className);
        if (clazz == null) {
            return false;
        }
        return wantedInterface.isAssignableFrom(clazz);
    }

    private static Class<?> createClassFromClassName(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return clazz;
    }

    public static String getInvalidProfileNameMessage() {
        String invalidProfileNameMessage1 = "Valid characters are letters, digits, dot, space and underscore.";
        String invalidProfileNameMessage2 = " The name must begin with a letter or a digit and cannot have two separators in a row. Max length is 64 characters.";
        return invalidProfileNameMessage1 + invalidProfileNameMessage2;
    }

    public static String getInvalidProfileClassNameMessage() {
        return INVALID_CLASS;
    }

    public static boolean validateInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validatePositiveInteger(String value) {
        boolean result = true;
        try {
            int intValue = Integer.parseInt(value);
            if (intValue <= 0) {
                result = false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return result;
    }

    public static boolean validateDemical(String value) {
        BigDecimal bd = null;
        try {
            double d = Double.valueOf(value);
            bd = BigDecimal.valueOf(d);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bd != null;
    }

    public static boolean validatePositiveDemical(String value) {
        boolean result = true;
        BigDecimal bd = null;
        try {
            double d = Double.valueOf(value);
            bd = BigDecimal.valueOf(d);
            if (d <= 0.0) {
                result = false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return result && bd != null;
    }
}

