/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.helper;

import com.ericsson.em.emc.helper.Function0;
import jakarta.persistence.OptimisticLockException;

public class OptimisticRetry {
    private final int retries;

    public OptimisticRetry(int retries) {
        this.retries = retries;
    }

    public <T> T execute(Function0<T> block) throws OptimisticLockException {
        int tries = 1;
        while (true) {
            try {
                return block.call();
            }
            catch (OptimisticLockException optimisticLockException) {
                if (++tries < this.retries) continue;
                return block.call();
            }
            break;
        }
    }
}

