/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.helper;

import com.ericsson.em.emc.helper.Function;
import com.ericsson.em.emc.helper.Function0;
import jakarta.persistence.OptimisticLockException;

public class OptimisticParameterizedRetry<IN, OUT> {
    private final int retries;
    private final IN initial;
    private final Function0<IN> seed;

    public OptimisticParameterizedRetry(int retries, IN initial, Function0<IN> seed) {
        this.retries = retries;
        this.initial = initial;
        this.seed = seed;
    }

    public OUT execute(Function<IN, OUT> block) throws OptimisticLockException {
        int tries = 1;
        IN in = this.initial;
        while (true) {
            try {
                return block.apply(in);
            }
            catch (OptimisticLockException optimisticLockException) {
                in = this.seed.call();
                if (++tries < this.retries) continue;
                return block.apply(in);
            }
            break;
        }
    }
}

