/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.feature;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.em.emc.feature.EnrichedFeature;
import com.ericsson.em.emc.feature.FeatureName;
import com.ericsson.em.emc.feature.FeatureRemoteManager;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import com.ericsson.lwac.feature.Feature;
import com.ericsson.lwac.utilities.cli.table.CLIHeaders;
import com.ericsson.lwac.utilities.cli.table.CLITable;
import jakarta.ejb.EJB;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Command(name="feature", group="common")
@Parameters(separators="=")
@RemoteCommand
public class FeatureCommand {
    @EJB
    private FeatureRemoteManager featureRemoteManager;
    private static final String TERMS_AND_CONDITION = "Subject to the terms and conditions in your commercial agreement with Ericsson, activating a feature may incur additional licensing fees.";
    private static final String CONFIRM = "Do you want to proceed? [y/N]";
    private static final String OK = "y";

    private static void printFeatures(PrintWriter out, Collection<EnrichedFeature> features, boolean all) {
        List<EnrichedFeature> featuresList = features.stream().collect(Collectors.toList());
        CLITable.Builder table = CLITable.create().name("Features").header(new CLIHeaders("Status", "Feature"));
        if (all || FeatureCommand.shallDisplay(featuresList)) {
            Collections.sort(featuresList, FeatureCommand.comparator());
            for (EnrichedFeature feature : featuresList) {
                if (all) {
                    table.row(feature.isActive() ? "Active" : "Inactive", feature.getFeature().getName());
                    continue;
                }
                if (!feature.isActive()) continue;
                table.row("Active", feature.getFeature().getName());
            }
        }
        out.println(table.build());
    }

    private static void printPermissions(PrintWriter out, String feature, boolean active, Set<String> setOfPermissionNames) {
        CLITable.Builder table = CLITable.create().name(feature).status(active ? "Active" : "Inactive").header(new CLIHeaders("Permissions"));
        for (String permission : setOfPermissionNames) {
            table.row(permission);
        }
        out.println(table.build().toString());
    }

    private static Comparator<EnrichedFeature> comparator() {
        return new Comparator<EnrichedFeature>(){

            @Override
            public int compare(EnrichedFeature o1, EnrichedFeature o2) {
                if (o1.isActive() == o2.isActive()) {
                    return o1.getFeature().getName().compareTo(o2.getFeature().getName());
                }
                if (o1.isActive()) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static boolean shallDisplay(List<EnrichedFeature> bucket) {
        for (EnrichedFeature feature : bucket) {
            if (!feature.isActive()) continue;
            return true;
        }
        return false;
    }

    private boolean confirmationQuestion(String information, String query, String ok, PrintWriter printWriter) {
        boolean result = true;
        if (information != null) {
            printWriter.println(information);
        }
        try (Scanner scanner = new Scanner(System.in);){
            printWriter.println(query);
            if (!ok.equalsIgnoreCase(scanner.nextLine())) {
                result = false;
            }
        }
        return result;
    }

    public static class StringToFeatureConverter
    implements IStringConverter<Feature> {
        public Feature convert(String value) {
            return new FeatureName(value.trim());
        }
    }

    @Command(name="deactivate")
    @Parameters(commandDescription="Deactivates an individual feature", separators="=")
    public class DeactivateCommand
    implements RemoteAction {
        @Parameter(description="Feature", required=false, names={"--feature", "-f"}, converter=StringToFeatureConverter.class)
        private Feature feature;

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            PrintWriter out = environment.getOutputWriter();
            if (this.feature == null) {
                throw new ExecutionException("The parameter 'feature' must be defined.");
            }
            FeatureCommand.this.featureRemoteManager.deactivate(this.feature);
            out.println(String.format("Feature '%s' was deactivated.", this.feature.getName()));
            out.flush();
        }
    }

    @Command(name="activate")
    @Parameters(commandDescription="Activates an individual feature", separators="=")
    public class ActivateCommand
    implements RemoteAction {
        @Parameter(description="Feature", required=false, names={"--feature", "-f"}, converter=StringToFeatureConverter.class)
        private Feature feature;
        @Parameter(description="force activation", required=false, hidden=true, names={"--force"})
        private boolean force = false;

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            PrintWriter out = environment.getOutputWriter();
            if (this.force || FeatureCommand.this.confirmationQuestion(FeatureCommand.TERMS_AND_CONDITION, FeatureCommand.CONFIRM, FeatureCommand.OK, out)) {
                if (this.feature == null) {
                    throw new ExecutionException("The parameter 'feature' must be defined.");
                }
            } else {
                throw new ExecutionException("Command was aborted by user");
            }
            FeatureCommand.this.featureRemoteManager.activate(this.feature);
            out.println(String.format("Feature '%s' was activated.", this.feature.getName()));
            out.flush();
        }
    }

    @Command(name="permissions")
    @Parameters(separators="=", commandDescription="List permissions for a specific Feature")
    public class FeaturesCommand
    implements RemoteAction {
        @Parameter(description="Feature", required=true, names={"--feature", "-f"}, converter=StringToFeatureConverter.class)
        private Feature feature;

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            Set<String> setOfPermissionNames = FeatureCommand.this.featureRemoteManager.getPermissions(this.feature);
            TreeSet<String> sorted = new TreeSet<String>(setOfPermissionNames);
            boolean active = FeatureCommand.this.featureRemoteManager.isActive(this.feature);
            PrintWriter out = environment.getOutputWriter();
            FeatureCommand.printPermissions(out, this.feature.getName(), active, sorted);
            out.flush();
        }
    }

    @Command(name="list")
    @Parameters(commandDescription="List of installed and available features", separators="=")
    public class ListCommand
    implements RemoteAction {
        @Parameter(description="include non installed features", required=false, names={"--all", "-a"})
        private boolean all = false;

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            List<EnrichedFeature> features = FeatureCommand.this.featureRemoteManager.getFeatures();
            PrintWriter out = environment.getOutputWriter();
            FeatureCommand.printFeatures(out, features, this.all);
            out.flush();
        }
    }
}

