/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.externaladmininfo;

import com.ericsson.em.emc.externaladmininfo.ExternalAdminIdentity;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminInfo;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminInfoDAO;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminInfoManager;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminStatus;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

@Singleton
public class ExternalAdminInfoManagerBean
implements ExternalAdminInfoManager {
    private static final ExternalAdminInfo NOT_FOUND = null;
    @EJB
    private ExternalAdminInfoDAO externalAdminInfoDAO;

    @Override
    public void registerSuccessfulLogin(ExternalAdminIdentity userIdentity, LocalDateTime loginDateTime, Long profileId) {
        ExternalAdminInfo externalAdminInfo = this.externalAdminInfoDAO.findByUserIdentity(userIdentity.getIdentifier());
        if (externalAdminInfo == NOT_FOUND) {
            ExternalAdminInfo newExternalAdminInfo = ExternalAdminInfo.newBuilder().userIdentity(userIdentity.getIdentifier()).status(ExternalAdminStatus.ACTIVE).loginTimestamp(loginDateTime).profileId(profileId).build();
            this.externalAdminInfoDAO.create(newExternalAdminInfo);
        } else {
            ExternalAdminInfo.Builder externalAdminInfoBuilder = externalAdminInfo.buildUpon();
            externalAdminInfoBuilder.status(ExternalAdminStatus.ACTIVE);
            externalAdminInfoBuilder.loginTimestamp(loginDateTime);
            externalAdminInfoBuilder.lastLoginTimestamp(externalAdminInfo.getLoginTimestamp());
            externalAdminInfoBuilder.profileId(profileId);
            this.externalAdminInfoDAO.update(externalAdminInfoBuilder.build());
        }
    }

    @Override
    public LocalDateTime getLastLogin(ExternalAdminIdentity identity) {
        ExternalAdminInfo externalAdminInfo = this.externalAdminInfoDAO.findByUserIdentity(identity.getIdentifier());
        if (externalAdminInfo == NOT_FOUND) {
            return null;
        }
        return externalAdminInfo.getLastLoginTimestamp();
    }

    @Override
    public Optional<Long> getProfileId(ExternalAdminIdentity identity) {
        ExternalAdminInfo externalAdminInfo = this.externalAdminInfoDAO.findByUserIdentity(identity.getIdentifier());
        if (externalAdminInfo == NOT_FOUND) {
            return null;
        }
        return Optional.ofNullable(externalAdminInfo.getProfileId());
    }

    @Override
    public List<ExternalAdminInfo> getUsersNotLoggedInSince(ZonedDateTime zonedDateTime) {
        return this.externalAdminInfoDAO.findUsersNotLoggedInSince(zonedDateTime);
    }

    @Override
    public void setInactiveStatus(ExternalAdminIdentity userIdentity) {
        ExternalAdminInfo externalAdminInfo = this.externalAdminInfoDAO.findByUserIdentity(userIdentity.getIdentifier());
        if (externalAdminInfo != null) {
            ExternalAdminInfo.Builder externalAdminInfoBuilder = externalAdminInfo.buildUpon();
            externalAdminInfoBuilder.status(ExternalAdminStatus.INACTIVE);
            this.externalAdminInfoDAO.update(externalAdminInfoBuilder.build());
        }
    }
}

