/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.externaladmininfo;

import com.ericsson.em.emc.externaladmininfo.ExternalAdminIdentity;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminStatus;
import com.ericsson.em.validation.Validation;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.persistence.Entity;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Entity
@Validatable
public final class ExternalAdminInfo
extends BaseEntity {
    @NotNull
    private final ExternalAdminIdentity userIdentity;
    @NotNull
    private final LocalDateTime loginTimestamp;
    @NotNull
    private final ExternalAdminStatus status;
    private final LocalDateTime lastLoginTimestamp;
    private final long profileId;

    private ExternalAdminInfo(Builder builder) {
        this.mId = builder.mId;
        this.userIdentity = builder.userIdentity;
        this.status = builder.status;
        this.loginTimestamp = builder.loginTimestamp;
        this.lastLoginTimestamp = builder.lastLoginTimestamp;
        this.profileId = builder.profileId;
    }

    public String getUserIdentity() {
        return this.userIdentity.getIdentifier();
    }

    public ExternalAdminStatus getStatus() {
        return this.status;
    }

    public LocalDateTime getLoginTimestamp() {
        return this.loginTimestamp;
    }

    public LocalDateTime getLastLoginTimestamp() {
        return this.lastLoginTimestamp;
    }

    public long getProfileId() {
        return this.profileId;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Long mId;
        private ExternalAdminIdentity userIdentity;
        private ExternalAdminStatus status;
        private LocalDateTime loginTimestamp;
        private LocalDateTime lastLoginTimestamp;
        private long profileId;

        private Builder() {
        }

        private Builder(ExternalAdminInfo externalAdminInfo) {
            this.mId = externalAdminInfo.mId;
            this.userIdentity = externalAdminInfo.userIdentity;
            this.status = externalAdminInfo.status;
            this.loginTimestamp = externalAdminInfo.loginTimestamp;
            this.lastLoginTimestamp = externalAdminInfo.lastLoginTimestamp;
            this.profileId = externalAdminInfo.profileId;
        }

        public Builder userIdentity(String userIdentity) {
            this.userIdentity = ExternalAdminIdentity.create(userIdentity);
            return this;
        }

        public Builder status(ExternalAdminStatus status) {
            this.status = status;
            return this;
        }

        public Builder loginTimestamp(LocalDateTime loginTimestamp) {
            this.loginTimestamp = loginTimestamp;
            return this;
        }

        public Builder lastLoginTimestamp(LocalDateTime lastLoginTimestamp) {
            this.lastLoginTimestamp = lastLoginTimestamp;
            return this;
        }

        public Builder profileId(long profileId) {
            this.profileId = profileId;
            return this;
        }

        public Builder mId(Long mId) {
            this.mId = mId;
            return this;
        }

        public ExternalAdminInfo build() {
            return Validation.validate(new ExternalAdminInfo(this));
        }
    }
}

