/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.csv;

import com.ericsson.em.emc.csv.CsvFileInfo;
import com.ericsson.em.validators.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class PayeeCsvFileInfo
extends CsvFileInfo {
    @NotEmpty
    private final String accountId;

    private PayeeCsvFileInfo(String accountId, String fileNamePrefix) {
        super(fileNamePrefix);
        this.accountId = accountId;
    }

    @Override
    public String generateFileName(String format, String fileExtension) {
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern("YYYY-MM-dd");
        return String.format(format, this.getFileNamePrefix(), this.accountId, dateFormat.print(new DateTime().toInstant().getMillis()), fileExtension);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvFileInfo.Builder<PayeeCsvFileInfo, Builder> {
        private String accountId;

        private Builder() {
        }

        @Override
        protected PayeeCsvFileInfo createCsvFileInfo(String fileNamePrefix) {
            return new PayeeCsvFileInfo(this.accountId, fileNamePrefix);
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }
    }
}

