/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.certificate.Certificate;
import com.ericsson.em.emc.credential.persistence.CertificateCredential;
import com.ericsson.em.emc.credential.persistence.CertificateCredentialDAO;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.certificatecredential.S"})
public class CertificateCredentialDAOBean
extends CryptoExtendedBaseEntityDAOBean<CertificateCredential>
implements CertificateCredentialDAO {
    private static final String[] COLUMNS = new String[]{"id", "fk_credentialownerreference", "fk_certificate", "logintimestamp", "lastlogintimestamp", "fingerprint", "fingerprintversion", "fingerprintkeygeneration"};
    private static final int CERTIFICATE_CREDENTIAL_CURRENT_FINGERPRINT_VERSION = 1;
    public static final String CERTIFICATE_CREDENTIAL_FINGERPRINT_KEY = "emm.certificatecredential.S";

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        CertificateCredential certificateCredential = (CertificateCredential)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, certificateCredential.getCredentialOwnerReferenceId());
        preparedStatement.setLong(i++, certificateCredential.getCertificateId());
        if (certificateCredential.getLoginTimestamp() != null) {
            preparedStatement.setObject(i++, (Object)CertificateCredentialDAOBean.getTimestamp((DateTime)certificateCredential.getLoginTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (certificateCredential.getLastLoginTimestamp() != null) {
            preparedStatement.setObject(i++, (Object)CertificateCredentialDAOBean.getTimestamp((DateTime)certificateCredential.getLastLoginTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(i++, 93);
        }
        i = this.assignFingerprint(preparedStatement, i, new Object[]{certificateCredential.getCredentialOwnerReferenceId(), certificateCredential.getCertificateId(), certificateCredential.getLoginTimestamp(), certificateCredential.getLastLoginTimestamp()});
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CertificateCredential certificateCredential = (CertificateCredential)baseEntity;
        certificateCredential.setCredentialOwnerReferenceId(resultSet.getLong("fk_credentialownerreference"));
        certificateCredential.setCertificateId(resultSet.getLong("fk_certificate"));
        Timestamp loginTimestamp = resultSet.getTimestamp("logintimestamp");
        Timestamp lastLoginTimestamp = resultSet.getTimestamp("lastlogintimestamp");
        certificateCredential.setLoginTimestamp(loginTimestamp == null ? null : new DateTime(loginTimestamp.getTime()));
        certificateCredential.setLastLoginTimestamp(lastLoginTimestamp == null ? null : new DateTime(lastLoginTimestamp.getTime()));
    }

    protected CertificateCredential createManagedEntity() {
        return new CertificateCredential();
    }

    @Override
    public CertificateCredential find(long id) {
        return (CertificateCredential)super.find(id);
    }

    @Override
    public CertificateCredential findByCredentialOwnerReference(CredentialOwnerReference credentialOwnerReference) {
        return (CertificateCredential)this.find(this.getSelectStatement() + " where fk_credentialownerreference = ? ", new Object[]{credentialOwnerReference.getId()});
    }

    @Override
    public CertificateCredential create(CertificateCredential certificateCredential) {
        return (CertificateCredential)super.create((BaseEntity)certificateCredential);
    }

    @Override
    public void delete(CertificateCredential certificateCredential) {
        super.delete((BaseEntity)certificateCredential);
    }

    @Override
    public CertificateCredential update(CertificateCredential certificateCredential) {
        return (CertificateCredential)super.update((BaseEntity)certificateCredential);
    }

    protected String getEntitySimpleName() {
        return CertificateCredential.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return CERTIFICATE_CREDENTIAL_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getLong("fk_credentialownerreference"), resultSet.getLong("fk_certificate"), resultSet.getTimestamp("logintimestamp"), resultSet.getTimestamp("lastlogintimestamp")};
        }
        return null;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return "emm$certificatecredential_seq";
    }

    public String getTableName() {
        return "emm$certificatecredential";
    }

    public boolean isUpdatable() {
        return true;
    }

    public boolean isVersionable() {
        return false;
    }

    @Override
    public CertificateCredential findByCertificate(Certificate certificate) {
        return (CertificateCredential)this.find(this.getSelectStatement() + " where fk_certificate = ?", new Object[]{certificate.getId()});
    }
}

