/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential;

import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.CredentialResetHandler;
import com.ericsson.em.emc.credential.CredentialStatus;
import com.ericsson.em.emc.credential.CredentialTypeProvider;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.credential.serviceprovider.PasswordServiceProvider;
import com.ericsson.lwac.security.session.Identity;
import jakarta.ejb.Local;
import java.util.List;

@Local
public interface CredentialManager {
    public void registerPasswordServiceProvider(Class<? extends CredentialOwner> var1, PasswordServiceProvider var2);

    public void registerCredentialTypeProvider(String var1, CredentialTypeProvider var2);

    public Credential createCredential(CredentialOwner var1, CredentialType var2, String var3);

    public Credential createCredential(CredentialOwner var1, CredentialType var2, String var3, String var4);

    public Credential createCredential(CredentialOwner var1, String var2, String var3);

    public Credential createCredential(CredentialOwner var1, String var2, String var3, String var4);

    public Credential createCredential(CredentialOwner var1, String var2, String var3, CredentialStatus var4);

    public Credential createCredential(CredentialOwner var1, String var2, String var3, String var4, CredentialStatus var5);

    public Credential updateCredential(CredentialOwner var1, String var2, String var3, String var4, String var5);

    public Credential updateCredentialAndAuditLog(Identity var1, CredentialOwner var2, String var3, String var4, String var5, String var6);

    public List<Credential> getCredentialsByOwner(CredentialOwner var1);

    public Credential getCredentialByOwnerAndCredentialType(CredentialOwner var1, CredentialType var2);

    public Credential getCredentialByOwnerAndCredentialType(CredentialOwner var1, String var2);

    public Credential getCredentialByOwnerReferenceAndCredentialType(CredentialOwnerReference var1, CredentialType var2);

    public List<CredentialHistory> getLatestByCredentialOwnerAndCredentialType(CredentialOwner var1, CredentialType var2, int var3);

    public CredentialType getCredentialType(String var1);

    public Credential block(Credential var1, String var2);

    public Credential unblock(Credential var1);

    public Credential inactivate(Credential var1);

    public Credential activate(Credential var1);

    public void registerSuccessfulLogin(CredentialOwner var1, String var2);

    public void registerUnsuccessfulLogin(CredentialOwner var1, String var2);

    public Credential createVoidCredential(CredentialOwner var1, CredentialType var2);

    public Credential createVoidCredential(CredentialOwner var1, CredentialType var2, CredentialStatus var3);

    public void registerUnsuccessfulReset(CredentialOwner var1, String var2);

    public void validateSecret(CredentialOwner var1, String var2);

    public void validateSecretStrength(CredentialOwner var1, String var2);

    public String generateRandomSecret(CredentialOwner var1);

    public void resetCredential(CredentialOwner var1, String var2, String var3, String var4, CredentialStatus var5);

    public boolean authenticate(CredentialOwner var1, Credential var2, String var3);

    public boolean authenticate(CredentialOwner var1, Credential var2, String var3, String var4);

    public void registerOnResetHandler(CredentialResetHandler var1);
}

