/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.audittrail.comparator.impl;

import com.ericsson.lwac.crypto.EncryptedField;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.utilities.DateUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class EntityReflectionComparator<T extends BaseEntity> {
    public Map<String, String[]> getChangedFields(T entityBefore, T entityAfter) throws IllegalAccessException, InvocationTargetException {
        if (entityAfter == null || entityBefore == null) {
            throw new IllegalArgumentException("Comparable entities cannot be null");
        }
        TreeMap<String, String[]> toReturn = new TreeMap<String, String[]>();
        for (Method m : entityBefore.getClass().getMethods()) {
            String sAfter;
            if ((m.getModifiers() & 1) != 1) continue;
            String methodName = m.getName();
            if (m.getParameterCount() != 0 || methodName.startsWith("getVersion") || methodName.startsWith("getChildren") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            String remove = methodName.startsWith("get") ? "get" : "is";
            String fieldName = methodName.substring(remove.length());
            Object before = m.invoke(entityBefore, new Object[0]);
            Object after = m.invoke(entityAfter, new Object[0]);
            if (after instanceof EncryptedField) {
                if (!((EncryptedField)after).hasChanged()) continue;
                toReturn.put(fieldName, new String[]{"", ""});
                continue;
            }
            String sBefore = this.getStringRepresentationOfField(before);
            if (sBefore.equals(sAfter = this.getStringRepresentationOfField(after))) continue;
            toReturn.put(fieldName, new String[]{sBefore, sAfter});
        }
        return toReturn;
    }

    private String getStringRepresentationOfField(Object field) {
        if (field == null) {
            return "";
        }
        if (field instanceof BaseEntity) {
            return ((BaseEntity)field).getId().toString();
        }
        if (field instanceof Collection) {
            Collection list = (Collection)field;
            return "Size: " + list.size();
        }
        if (field instanceof byte[]) {
            return "Hash: " + Arrays.hashCode((byte[])field);
        }
        if (field instanceof DateTime) {
            return DateUtilities.getReadableDate((DateTime)field);
        }
        return field.toString();
    }
}

