/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.activator;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.lwac.application.ActivationException;
import com.ericsson.lwac.application.Activator;
import com.ericsson.lwac.versions.Version;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Local(value={Activator.class})
public class ProfileServiceActivator
implements Activator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileServiceActivator.class);
    @EJB
    private ProfileServiceDAO profileServiceDAO;
    @EJB
    private ProfileDAO profileDAO;
    private static final String SERVICE_PERMISSIONS = "Permissions";
    private static final String ROLE_VIEW_ANY_APPROVALS = "ROLE_VIEW_ANY_APPROVALS";
    private static final String ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS = "ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS";

    @Override
    public void onActivate(Version previousVersion, Version newVersion) throws ActivationException {
        if (previousVersion == null || previousVersion.getVersionString().isEmpty()) {
            LOGGER.info("New installation for version {}", (Object)newVersion);
        } else {
            LOGGER.info("Upgrade to version {}", (Object)newVersion);
        }
        this.createProfileServicesWithNewPermission(ROLE_VIEW_ANY_APPROVALS);
    }

    private void createProfileServicesWithNewPermission(String refPermission) {
        Optional<ProfileService> serviceParent = null;
        List<Profile> profiles = this.profileDAO.findByPermission(refPermission);
        for (Profile profile : profiles) {
            if (serviceParent == null) {
                serviceParent = profile.getServices().stream().filter(x -> x.getName().equals(SERVICE_PERMISSIONS)).findFirst();
            }
            if (!serviceParent.isPresent()) continue;
            ProfileService serviceChild = new ProfileService(ROLE_VIEW_ACCOUNTHOLDER_INITIATED_APPROVALS);
            this.profileServiceDAO.create(serviceChild, serviceParent.get());
        }
    }
}

