/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc;

import com.ericsson.em.emc.UserErrorCode;
import java.util.Map;
import java.util.Objects;

public class UserException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final UserErrorCode errorCode;
    private final Map<String, Object> arguments;
    private final Map<String, Object> extraArguments;
    private final UserErrorCode originalErrorCode;

    UserException(UserErrorCode errorCode, Map<String, Object> arguments, Map<String, Object> extraArguments) {
        super(errorCode.toString());
        this.errorCode = errorCode;
        this.arguments = arguments;
        this.extraArguments = extraArguments;
        this.originalErrorCode = null;
    }

    UserException(UserErrorCode errorCode, Map<String, Object> arguments, Map<String, Object> extraArguments, UserErrorCode originalErrorCode) {
        super(errorCode.toString(), new RuntimeException(originalErrorCode.toString()));
        this.errorCode = errorCode;
        this.arguments = arguments;
        this.extraArguments = extraArguments;
        this.originalErrorCode = originalErrorCode;
    }

    public UserErrorCode getErrorCode() {
        return this.errorCode;
    }

    public UserErrorCode getOriginalErrorCode() {
        return this.originalErrorCode;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public Map<String, Object> getExtraArguments() {
        return this.extraArguments;
    }

    public Object[] getArgumentList() {
        Object[] result = new Object[this.errorCode.getArgumentNames().size()];
        int i = 0;
        for (String name : this.errorCode.getArgumentNames()) {
            result[i] = this.arguments.get(name);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer returnStringBuf = new StringBuffer(this.errorCode.toString());
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            returnStringBuf.append(", ");
            returnStringBuf.append(e.getKey());
            returnStringBuf.append(" = ");
            returnStringBuf.append(e.getValue());
        }
        if (this.originalErrorCode != null) {
            returnStringBuf.append(", ");
            returnStringBuf.append(this.originalErrorCode.toString());
        }
        return returnStringBuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserException that = (UserException)o;
        return Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.extraArguments, that.extraArguments) && Objects.equals(this.originalErrorCode, that.originalErrorCode);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.arguments, this.extraArguments, this.originalErrorCode);
    }
}

