/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberRangeDocument
extends PlainDocument
implements FieldValidation {
    private long myMin = Long.MIN_VALUE;
    private long myMax = Long.MAX_VALUE;
    private StatusInterface myStatus = null;
    private boolean isEnabled = true;

    public NumberRangeDocument() {
    }

    public NumberRangeDocument(long min, long max) {
        this.myMin = min;
        this.myMax = max;
    }

    public long getMinValue() {
        return this.myMin;
    }

    public void setMinValue(long v) {
        this.myMin = v;
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(long v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String numbersOnlyString = "";
        int start = 0;
        if (this.myMin < 0L && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            if (chars[i] == '-' && this.getText(0, this.getLength()).indexOf(45) == -1) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            if (this.myStatus == null) continue;
            this.myStatus.beep();
            this.myStatus.printMessage("Only digits '0-9' allowed");
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.isValid(proposedResult)) {
            super.insertString(offs, numbersOnlyString, a);
        }
    }

    @Override
    public boolean isValid(String str) {
        boolean valid;
        block10: {
            valid = true;
            String msg = "";
            if (str.length() < 1) {
                valid = false;
                msg = "No digits, not a numeric value";
            }
            if (valid && !this.onlyValidCharactersInString(str)) {
                valid = false;
                msg = "'" + str + "' is NOT Valid, only digits '0-9' allowed ";
            }
            try {
                long longProposedResult;
                if (valid && str.indexOf("-") != -1) {
                    if (str.length() > 1) {
                        long startNumber = Long.parseLong(str.substring(0, str.indexOf("-")));
                        long endNumber = Long.parseLong(str.substring(str.indexOf("-") + 1, str.length()));
                        if (!this.checkRange(startNumber) || !this.checkRange(endNumber)) {
                            valid = false;
                            msg = "Value '" + str + "' out of range, must be within " + this.myMin + " >= value <= " + this.myMax;
                        }
                    }
                } else if (valid && str.indexOf("-") == -1 && ((longProposedResult = Long.parseLong(str)) > this.myMax || longProposedResult < this.myMin)) {
                    valid = false;
                    msg = "Value '" + str + "' out of range, must be within " + this.myMin + " >= value <= " + this.myMax;
                }
                if (!valid && this.myStatus != null) {
                    this.myStatus.beep();
                    this.myStatus.printMessage(msg);
                }
            }
            catch (NumberFormatException e) {
                if (this.myStatus == null) break block10;
                this.myStatus.beep();
                this.myStatus.printMessage("Value '" + str + "' out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            }
        }
        return valid;
    }

    private boolean onlyValidCharactersInString(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || chars[i] == '-') continue;
            return false;
        }
        return true;
    }

    private boolean checkRange(long longProposedResult) {
        return longProposedResult <= this.myMax && longProposedResult >= this.myMin;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatus = statusHandler;
    }

    public StatusInterface getStatusHandler() {
        return this.myStatus;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

