/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractSingleDataItem;

public class LongDataItem
extends AbstractSingleDataItem {
    private long myValue;
    private long myMin = Long.MIN_VALUE;
    private long myMax = Long.MAX_VALUE;

    public LongDataItem(long value) {
        super(new Long(value));
        this.myValue = value;
    }

    public LongDataItem(long value, long min, long max) {
        super(new Long(value));
        this.myValue = value;
        this.myMin = min;
        this.myMax = max;
    }

    @Override
    public Object getDataItem(Object reference) {
        return new Long(this.myValue);
    }

    @Override
    public Object getDataItem() {
        return new Long(this.myValue);
    }

    @Override
    protected boolean performSetDataItem(Object reference, Object object) {
        if (object instanceof Long) {
            this.myValue = (Long)object;
        } else {
            String value = object.toString();
            try {
                this.myValue = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public long getValue() {
        return this.myValue;
    }

    public void setValue(long value) {
        this.setDataItem(null, new Long(value));
    }

    public long getMinValue() {
        return this.myMin;
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public String toString() {
        return Long.toString(this.myValue);
    }
}

