/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common;

import java.io.PrintWriter;
import java.io.StringWriter;

public class NestingException
extends Exception {
    private Throwable nestedException;
    private String stackTraceString;

    public static String generateStackTraceString(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public NestingException() {
    }

    public NestingException(String msg) {
        super(msg);
    }

    public NestingException(Throwable nestedException) {
        this.nestedException = nestedException;
        this.stackTraceString = NestingException.generateStackTraceString(nestedException);
    }

    public NestingException(String msg, Throwable nestedException) {
        this(msg);
        this.nestedException = nestedException;
        this.stackTraceString = NestingException.generateStackTraceString(nestedException);
    }

    public Throwable getNestedException() {
        return this.nestedException;
    }

    public String getStackTraceString() {
        if (this.nestedException == null) {
            return null;
        }
        StringBuffer traceBuffer = new StringBuffer();
        if (this.nestedException instanceof NestingException) {
            traceBuffer.append(((NestingException)this.nestedException).getStackTraceString());
            traceBuffer.append("-------- nested by:\n");
        }
        traceBuffer.append(this.stackTraceString);
        return traceBuffer.toString();
    }

    @Override
    public String getMessage() {
        String superMsg = super.getMessage();
        if (this.getNestedException() == null) {
            return superMsg;
        }
        StringBuffer theMsg = new StringBuffer();
        String nestedMsg = this.getNestedException().getMessage();
        if (superMsg != null) {
            theMsg.append(superMsg).append(": ").append(nestedMsg);
        } else {
            theMsg.append(nestedMsg);
        }
        return theMsg.toString();
    }

    @Override
    public String toString() {
        StringBuffer theMsg = new StringBuffer(super.toString());
        if (this.getNestedException() != null) {
            theMsg.append("; \n\t---> nested ").append(this.getNestedException());
        }
        return theMsg.toString();
    }
}

