/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.calendar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;

public final class CalendarDate
implements Comparable<CalendarDate>,
Serializable {
    private static final int DAYS_BETWEEN_0_AND_19700101 = 719527;
    public static final int SUNDAY = 7;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    private int daysSince19700101 = -1;
    private int myYear;
    private int myMonth;
    private int myDayOfMonth;
    private static DateHolder[] dateIn4Year = new DateHolder[1461];
    private static final int[] cumulDaysToMonth = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final CalendarDate EPOCH_19700101 = new CalendarDate(1970, 1, 1);

    public CalendarDate(int year, int month, int dayOfMonth) {
        this(year, month, dayOfMonth, false);
    }

    public CalendarDate(int days19700101) {
        this.initFromDaysSince19700101(days19700101);
    }

    private CalendarDate(int year, int month, int dayOfMonth, boolean lenient) {
        if (!lenient) {
            this.checkValidYearMonthDay(year, month, dayOfMonth);
        }
        this.init(year, month, dayOfMonth);
    }

    private void init(int y, int m, int d) {
        this.myYear = y;
        this.myMonth = m;
        this.myDayOfMonth = d;
        this.correctNonLenientFieldsIfNecessary();
        if (CalendarDate.yearOutOfRange(this.getYear())) {
            throw new IllegalArgumentException("Date year out of range: " + y);
        }
        this.getDaysSince19700101();
    }

    private void correctNonLenientFieldsIfNecessary() {
        if (!CalendarDate.isValidYearMonthDay(this.myYear, this.myMonth, this.myDayOfMonth)) {
            GregorianCalendar cal = new GregorianCalendar(this.myYear, this.myMonth - 1, this.myDayOfMonth);
            this.myYear = cal.get(1);
            this.myMonth = cal.get(2) + 1;
            this.myDayOfMonth = cal.get(5);
        }
    }

    private static boolean isValidYearMonthDay(int year, int month, int dayOfMonth) {
        if (dayOfMonth == 29 && month == 2 && CalendarDate.isLeapYear(year)) {
            return true;
        }
        if (month <= 0 || month > 12) {
            return false;
        }
        return dayOfMonth > 0 && dayOfMonth <= daysInMonth[month - 1];
    }

    private static boolean yearOutOfRange(int year) {
        return year < 1970 || year >= 2100;
    }

    private void checkValidYearMonthDay(int y, int m, int d) {
        if (!CalendarDate.isValidYearMonthDay(y, m, d)) {
            throw new IllegalArgumentException("Year/month/day combination is invalid: " + y + "/" + m + "/" + d);
        }
    }

    public int getDayOfMonth() {
        return this.myDayOfMonth;
    }

    public int getDayOfWeek() {
        int weekDay = this.daysSince19700101 % 7 + 4;
        if (weekDay >= 7) {
            weekDay -= 7;
        }
        return weekDay;
    }

    public int getMonth() {
        return this.myMonth;
    }

    public int getYear() {
        return this.myYear;
    }

    public CalendarDate addDays(int numDays) {
        return new CalendarDate(this.daysSince19700101 + numDays);
    }

    public int daysUntil(CalendarDate otherDay) {
        return otherDay.daysSince19700101 - this.daysSince19700101;
    }

    public int monthsUntil(CalendarDate otherDay) {
        return otherDay.getMonth() - this.getMonth() + 12 * (otherDay.getYear() - this.getYear());
    }

    private static int daysToYear(int year) {
        return 365 * year + CalendarDate.numLeapsToYear(year);
    }

    private static int numLeapsToYear(int year) {
        int num4y = (year - 1) / 4;
        int num100y = (year - 1) / 100;
        int num400y = (year - 1) / 400;
        int numLeaps = num4y - num100y + num400y;
        return numLeaps;
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    @Override
    public int compareTo(CalendarDate other) {
        return this.daysSince19700101 - other.daysSince19700101;
    }

    public boolean isBefore(CalendarDate other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(CalendarDate other) {
        return this.compareTo(other) > 0;
    }

    public boolean equals(Object other) {
        if (other instanceof CalendarDate) {
            return this.compareTo((CalendarDate)other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 375 * this.getYear() + 35 * this.getMonth() + this.getDayOfMonth();
    }

    public String toString() {
        return new StringBuffer().append(this.getYear()).append("-").append(this.getMonth()).append("-").append(this.getDayOfMonth()).toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getYear());
        out.writeInt(this.getMonth());
        out.writeInt(this.getDayOfMonth());
        out.writeInt(this.daysSince19700101);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init(in.readInt(), in.readInt(), in.readInt());
        this.daysSince19700101 = in.readInt();
    }

    public static int daysInMonth(int year, int month) {
        int result = daysInMonth[month - 1];
        if (month == 2 && CalendarDate.isLeapYear(year)) {
            ++result;
        }
        return result;
    }

    public CalendarDate addMonths(int numMonths) {
        int newMonthsSinceEpoch = this.getYear() * 12 + this.getMonth() + numMonths - 1;
        int newYear = newMonthsSinceEpoch / 12;
        int newMonth = newMonthsSinceEpoch % 12 + 1;
        int newDay = Math.min(this.getDayOfMonth(), CalendarDate.daysInMonth(newYear, newMonth));
        return new CalendarDate(newYear, newMonth, newDay);
    }

    private void initFromDaysSince19700101(int days) {
        int full4Year = days / 1461;
        int remainingDays = days - full4Year * 1461;
        DateHolder date = dateIn4Year[remainingDays];
        this.myYear = 1970 + date.year + full4Year * 4;
        this.myMonth = date.month;
        this.myDayOfMonth = date.days;
        this.daysSince19700101 = days;
        if (CalendarDate.yearOutOfRange(this.myYear)) {
            throw new IllegalArgumentException("Date year out of range: " + this.myYear);
        }
    }

    public int getDaysSince19700101() {
        if (this.daysSince19700101 == -1) {
            int y = this.getYear();
            int m = this.getMonth();
            int daysThisYear = cumulDaysToMonth[m - 1] + this.getDayOfMonth() - 1;
            if (m > 2 && CalendarDate.isLeapYear(y)) {
                ++daysThisYear;
            }
            this.daysSince19700101 = CalendarDate.daysToYear(y) + daysThisYear - 719527;
        }
        return this.daysSince19700101;
    }

    static {
        int year = 0;
        int month = 1;
        int day = 1;
        for (int i = 0; i < 1461; ++i) {
            DateHolder date;
            CalendarDate.dateIn4Year[i] = date = new DateHolder(year, month, day);
            if (++day <= CalendarDate.daysInMonth(1970 + year, month)) continue;
            day = 1;
            if (++month <= 12) continue;
            month = 1;
            ++year;
        }
    }

    private static class DateHolder {
        int year;
        int month;
        int days;

        public DateHolder(int y, int m, int d) {
            this.year = y;
            this.month = m;
            this.days = d;
        }
    }
}

